# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Find unique characters between two same letters.

# Approach
<!-- Describe your approach to solving the problem. -->
- Created array to store first and last occurance of all 26 letters
- Checked between first and last occurance of every character : number of distinct characters present between will be the number of substrings possible ( of length 3) 
- - firstoccurance - character in between - lastoccurance : resembles length 3

---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(n)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(n) = O(1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int countPalindromicSubsequence(String s) {
        // Created array to store first and last occurance of all 26 letters
        int[] firstoccurance = new int[26];
        int[] lastoccurance = new int[26];
        //Initially fill 'firstoccurance' with last possible index
        Arrays.fill(firstoccurance, s.length());

        for( int i = 0; i < s.length(); i++){
            int character = s.charAt(i) - 'a';
            firstoccurance[character] = Math.min( firstoccurance[character], i);
            lastoccurance[character] = i;
        }

        // Now check between first and last occurance of every character : number of distinct characters present between will be the number of substrings possible ( of length 3) 
        // firstoccurance - character in between - lastoccurance : resembles length 3

        int a = 0;    // to store answer
        for( int i = 0; i < 26; i++){
            if( firstoccurance[i] < lastoccurance[i]){
                long number_of_distinct_characters = s.substring( firstoccurance[i] + 1,  lastoccurance[i] ).chars().distinct().count();
                a +=   number_of_distinct_characters;
            }
        }
        return a;
    }
}
```